/*

	Script che aggiunge nella tabella dei movimenti IVA CG43_MOVIVA due nuovi campi
	necessari al trasferimento dei dati al Sistema Tessera Sanitaria (SISTEMA TS)
	per la normativa 2021/2022:
	- un campo indicatore che indica il tipo documento di spesa: 0-Automatico dal tipo registrazione ((F) Fattura/(D) Corrispettivo) 1-Fattura (F) 2-Documento commerciale (D)
	- un campo flag che indica se il cittadino ha esercitato l'opposizione all'invio del Codice Fiscale cifrato al sistema Tessera Sanitaria 0-No 1-Si

*/

-------------------------------------------------------------------------------------------------------------------------

IF NOT EXISTS(SELECT * FROM SYSCOLUMNS WHERE NAME = 'CG43_INDTSTIPODOC')
	BEGIN
		ALTER TABLE CG43_MOVIVA
			ADD CG43_INDTSTIPODOC TINYINT NOT NULL DEFAULT 0
		PRINT 'Tabella CG43_MOVIVA: campo CG43_INDTSTIPODOC creato'
	END
ELSE
	BEGIN
		PRINT 'Tabella CG43_MOVIVA: campo CG43_INDTSTIPODOC esistente, creazione non effettuata'
	END		
GO

-------------------------------------------------------------------------------------------------------------------------

IF NOT EXISTS(SELECT * FROM SYSCOLUMNS WHERE NAME = 'CG43_FLGTSOPPOSIZ')
	BEGIN
		ALTER TABLE CG43_MOVIVA
			ADD CG43_FLGTSOPPOSIZ TINYINT NOT NULL DEFAULT 0
		PRINT 'Tabella CG43_MOVIVA: campo CG43_FLGTSOPPOSIZ creato'
	END
ELSE
	BEGIN
		PRINT 'Tabella CG43_MOVIVA: campo CG43_FLGTSOPPOSIZ esistente, creazione non effettuata'
	END		
GO

-------------------------------------------------------------------------------------------------------------------------
